<?php
$ip = $_SERVER['REMOTE_ADDR'];
$limit = 2;
$windowSeconds = 1800; // 1 hour
$logFile = __DIR__ . '/ip_logs.json';

// Initialize log
if (!file_exists($logFile)) {
    file_put_contents($logFile, json_encode([]));
}

// Read existing logs
$logs = json_decode(file_get_contents($logFile), true);

// Clean expired logs
$now = time();
if (!isset($logs[$ip])) {
    $logs[$ip] = [];
}
$logs[$ip] = array_filter($logs[$ip], fn($timestamp) => $timestamp >= $now - $windowSeconds);

// Check attempts
if (count($logs[$ip]) >= $limit) {
    echo "<!DOCTYPE html>
    <html><head><meta charset='UTF-8'>
        <style>
            body {
                background-color: orange;
                margin: 0;
                height: 100vh;
                display: flex;
                justify-content: center;
                align-items: center;
            }
        </style>
    <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script></head>
    <body><script>
        Swal.fire({
            icon: 'error',
            title: 'Too Many Requests',
            text: 'Please wait before submitting again.'
        }).then(() => {
            window.history.back();
        });
    </script></body></html>";
    exit;
}

// Log current attempt
$logs[$ip][] = $now;
file_put_contents($logFile, json_encode($logs));

require __DIR__ . '/vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);

try {
    $email = $_POST['sender-address'] ?? '';
    $summarySender = $_POST['summary_sender'] ?? '';
    $summaryReceiver = $_POST['summary_receiver'] ?? '';
    $summaryPackage = $_POST['summary_package'] ?? '';

    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'error' => 'Invalid or missing sender email.']);

        exit;
    }

    // SMTP Config
    $mail->isSMTP();
    $mail->Host = 'litexpress.com.ph';
    $mail->SMTPAuth = true;
    $mail->Username = 'c_lusanta.partners@litexpress.com.ph';
    $mail->Password = 'Password123$$##';
    $mail->SMTPSecure = 'ssl'; // try 'tls' if this fails
    $mail->Port = 465; // try 587 for TLS

    // Email
    $mail->setFrom($email, 'LiteXpress Form');
    $mail->addAddress('infotech@litexpress.com.ph');
    $mail->isHTML(true);
    $mail->Subject = 'New Package Delivery Submission';

    $mail->Body = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; }
            h2 { color: #007BFF; border-bottom: 1px solid #eee; }
            .section { margin-bottom: 20px; }
        </style>
    </head>
    <body>
        <h1>Shipping Details Summary</h1>

        <div class='section'>
            <h2>Sender Information</h2>
            <p>$summarySender</p>
        </div>

        <div class='section'>
            <h2>Receiver Information</h2>
            <p>$summaryReceiver</p>
        </div>

        <div class='section'>
            <h2>Package Details</h2>
            <p>$summaryPackage</p>
        </div>
    </body>
    </html>
    ";

    $mail->send();

    echo "
    <html>
    <head>
        <style>
            body {
                background-color: orange;
                margin: 0;
                height: 100vh;
                display: flex;
                justify-content: center;
                align-items: center;
            }
        </style>
        <script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
    </head>
    <body>
        <script>
        document.addEventListener('DOMContentLoaded', function () {
            Swal.fire({
            icon: 'success',
            title: 'Sent!',
            text: 'Submitted to LX successfully!',
            }).then(() => {
            window.location.href = 'index.html';
            });
        });
        </script>
    </body>
    </html>";

} catch (Exception $e) {
    echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
          <script>
            Swal.fire({
              icon: 'error',
              title: 'Oops!',
              text: 'Mailer Error: " . addslashes($mail->ErrorInfo ?? $e->getMessage()) . "'
            }).then(() => {
              window.history.back();
            });
          </script>";
}
